/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.syncing.ui.old.actions;

import com.aptana.ide.core.io.IConnectionPoint;
import com.aptana.ide.syncing.core.ISiteConnection;
import com.aptana.ide.syncing.core.old.ISyncEventHandler;
import com.aptana.ide.syncing.core.old.VirtualFileSyncPair;
import com.aptana.ide.syncing.core.old.handlers.SyncEventHandlerAdapter;
import com.aptana.ide.syncing.ui.navigator.ProjectSiteConnection;
import com.aptana.ide.syncing.ui.old.actions.Messages;
import com.aptana.ide.syncing.ui.old.views.SmartSyncDialog;
import com.aptana.ui.util.UIUtils;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class SiteConnectionSynchronizeAction
implements IObjectActionDelegate {
    private ISiteConnection fConnection;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        final IConnectionPoint source = this.fConnection.getSource();
        IConnectionPoint dest = this.fConnection.getDestination();
        try {
            SmartSyncDialog dialog = new SmartSyncDialog(UIUtils.getActiveShell(), source, dest, source.getRoot(), dest.getRoot(), source.getName(), dest.getName());
            dialog.open();
            dialog.setHandler((ISyncEventHandler)new SyncEventHandlerAdapter(){

                public void syncDone(VirtualFileSyncPair item, IProgressMonitor monitor) {
                    IResource resource = (IResource)source.getAdapter(IResource.class);
                    if (resource != null) {
                        try {
                            resource.refreshLocal(2, null);
                        }
                        catch (CoreException coreException) {
                            // empty catch block
                        }
                    }
                }
            });
        }
        catch (CoreException e) {
            MessageBox error = new MessageBox(UIUtils.getActiveShell(), 33);
            error.setMessage(Messages.SiteConnectionSynchronizeAction_UnableToOpenSyncDialog);
            error.open();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object element;
        this.fConnection = null;
        if (selection instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof ProjectSiteConnection) {
            this.fConnection = ((ProjectSiteConnection)((Object)element)).getSiteConnection();
        }
    }
}

